
#ifndef _1_MNG_ATP_TST_Defines_h_H
#define _1_MNG_ATP_TST_Defines_h_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */


#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Sep 11 07:21:17 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MNG_ATP_TST_Defines.h#1:incl:1
   *  \author NogaD
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/************************ Global Data **************************/
/************************ Defines ******************************/
/* Define for supported RKEK size - should be changed according to platform */
#define TST_RKEK_SIZE_16_BYTE	0

/* Defines for Enable log printouts */
/*----------------------------------*/
#define MNG_TST_LOG_ENABLE   0
#define MNG_LOG_FILE_NAME    "C:\TEMP\LOG\MNG_TST_Log.txt"

/* Arrays size Defines */
/*---------------------*/
#ifndef TST_FUNC_STRING_LEN
  #define TST_FUNC_STRING_LEN 100
#endif 
#ifndef TST_NAME_STRING_LEN
  #define TST_NAME_STRING_LEN 150
#endif 

/* Defines for debug*/
/*------------------*/
#ifndef DX_ARM1176
#define DX_TST_DBG_OTP_ADDR   0xc0020100
#else
#define DX_TST_DBG_OTP_ADDR   0x80004100
#endif
#define DX_TST_DBG_OTP_SIZE	  512
#define DX_TST_DEBUG_OTP      

/* General Defines */
/*-----------------*/
#define   MNG_TEST_PASS                 	0
#define   MNG_TEST_FAIL                 	1
#define   TST_MNG_MAX_AES_KEY_SIZE      	32
#define   TST_MNG_MAX_DATA_SIZE         	256
#define   TST_MAX_NUM_OF_MNG_ATP_TESTS  	10
#define   TST_MNG_MAX_NUM_OF_LOOPS      	10
#define   TST_MNG_MAX_COUNTER_SIZE			24
#ifndef DX_ARM1176
#define   MNG_TST_HW_SEP_SW_RST_REG_ADDR	0xC00080A8
#define   MNG_TST_HW_SNAPSHOT_REG_1			0xC00080E4
#define   MNG_TST_HW_SNAPSHOT_REG_2			0xC00080E0UL
#else
#define   MNG_TST_HW_SEP_SW_RST_REG_ADDR	0x800080A8
#define   MNG_TST_HW_SNAPSHOT_REG_1			0x800080E4
#define   MNG_TST_HW_SNAPSHOT_REG_2			0x800080E0UL
#endif

#define   TST_MNG_RND_SIZE						1000
#define	  TST_MNG_MAX_NUM_OF_LOOPS_FOR_RND_GEN	20
#define   TST_MNG_SIZE_TO_INCREASE				100
#define   MNG_TST_MAX_BUF_SIZE_IN_BYTES			4096
#define   DX_TST_MNG_SEED						0xABCD

/* State Defines */
/*---------------*/
#define TST_MNG_CHIP_MANUFACTURE_STATE			0x00
#define TST_MNG_DEVICE_MANUFACTURE_STATE		0x10
#define TST_MNG_SECURITY_DISABLED_STATE			0x30
#define TST_MNG_SECURE_STATE					0x50
#define TST_MNG_RMA_STATE						0xF0
#define TST_MNG_SPEC_SECURE_MODE				0x51


#define TST_MNG_LCS_CHIP_MANUFACTURE_IDX		0
#define TST_MNG_LCS_DEVICE_MANUFACTURE_IDX		1
#define TST_MNG_LCS_SECURITY_DISABLE_IDX		2
#define TST_MNG_LCS_SECURITY_OR_RMA_IDX			3	

#define TST_MNG_MAX_NUM_OF_STATES				4
#define TST_MNG_MAX_NUM_OF_STATES_DISABLE		3

/* Defines for Printing level */
/*----------------------------*/
#ifndef ATP_LOG_TST_MAX_LEVEL_ENABLED
  #define ATP_LOG_TST_MAX_LEVEL_ENABLED 20
#endif  
/* Print levels */
/*--------------*/
#ifndef MNG_ATP_TST_MSG
  #define MNG_ATP_TST_MSG 		    10
#endif  
#ifndef MNG_ATP_TST_DBG_HIGH
  #define MNG_ATP_TST_DBG_HIGH 	  20
#endif
#ifndef MNG_ATP_TST_DBG_MED
  #define MNG_ATP_TST_DBG_MED	    30
#endif
#ifndef MNG_ATP_TST_DBG_LOW
  #define MNG_ATP_TST_DBG_LOW 	  40
#endif  


#ifdef __cplusplus
}
#endif
 
#endif
